///////////////////////////////////////////////////////////////////////////////////
// Maciej Kucia Krakw 2010 sProgATM8                                            //
//                                                                               //
// Licencja MIT                                                                  //
///////////////////////////////////////////////////////////////////////////////////

// Ustawienia uart
#define BAUD 9600
#define BAUD_PRESCALE ((F_CPU + BAUD * 8L) / (BAUD * 16L) - 1) 

// Inne
#define SIGRD 5 // Nagwek boot.h nie zawiera tej definicji a powinien

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Biblioteki
#include <avr/boot.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <util/delay.h>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Pozwala wykona skok do kodu po zakoczeniu pracy bootloadera
static void (*jump_to_app)(void) = 0x0000;

//Wysya bajt przez uart
static void SendByte( const char Data )
{
	while( !( UCSRA & (1<<UDRE) ) );
	UDR = Data;
}

//Odbiera bajt przez uart
static uint8_t ReadByte(void)
{
	while ( !( UCSRA & (1<<RXC) ) );
	return UDR;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Rnoci zwizane z pozycj bootloadera w pamici
void skip(void) __attribute__ ((naked, section (".vectors") ));
void skip(void)
{
    asm volatile("rjmp setup");
}

void setup(void) __attribute__ ((naked, section (".init0") ));
void setup(void)
{
	//Wcz uart
	UBRRL = BAUD_PRESCALE;
	UBRRH = (BAUD_PRESCALE >> 8);
	UCSRB |= (1<<RXEN)|(1<<TXEN); 	
	UCSRC |= (1<<URSEL)|(1<<UCSZ0)|(1<<UCSZ1);
	// ^ dane:8 bitw, 1 bit parzystoci

	//Inicjacja stosu i rejestru statusu, daje rwnie czas dla uart na inicjalizacj
    asm volatile ( "clr __zero_reg__" );
    SREG = 0;   // Ustawiamy rej statusu
    SP = RAMEND; // i wsk stosu
} 


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
int main(void) __attribute__ ((naked, section (".init9"), OS_main, used )); 
int main(void)
{
	// Wysyamy znak zachty i czekamy na odpowiedz
	SendByte( '?' );
	_delay_loop_2(0); 

	//Sprawdzenie jeeli nie ma odpowiedzi lub rni si ona od 's' to bootloader skacze do programu
	if( ((UCSRA & (1 << RXC)) != 0 ) && (UDR == 's'))
	{
		//Wysyamy nagwek
		SendByte( 0xA0 ); // Oznaczenie wersji bootloadera
		SendByte( 0x32 ); // Oznaczenie ukadu: ATMega32
		SendByte( boot_lock_fuse_bits_get( GET_LOW_FUSE_BITS  ) );  //Fusebity
		SendByte( boot_lock_fuse_bits_get( GET_HIGH_FUSE_BITS ) );
		SendByte( boot_lock_fuse_bits_get( GET_LOCK_BITS      ) );
		
		uint8_t command;
		//Gwna ptla
		while ( 1 )
		{
			// Odczyt rozkazu 
			command = ReadByte();
			
			// === ZAPIS PAMICI FLASH ===
			if (command=='F')
			{
				uint8_t crc = 0xFF;
				// odczekanie do zakoczenia dziaa na EEPROM i flash 
				boot_spm_busy_wait();
				
				// Odebranie adresu
				uint8_t low  = ReadByte();
				crc^=low;
				uint8_t high = ReadByte();
				crc^=high;
				uint16_t pageAdress =  ( uint16_t )low + ( high <<8 );

				if( pageAdress >= BLS_START ) break;
				// Skasowanie strony
				boot_page_erase( pageAdress );
				boot_spm_busy_wait();
					
				//Znak gotowoci na dane
				SendByte( '>' );
					
				//Zapeniamy bufor strony
				for ( uint16_t Byte_Address = 0; Byte_Address < SPM_PAGESIZE; Byte_Address += 2 )
				{
					// przygotowanie 2 bajtowej instrukcji, obliczenie chksum i zapisanie bufora
					low  = ReadByte();
					high = ReadByte();
					crc^=low;
					crc^=high;
					uint16_t Instruction = (uint16_t)low + ( high << 8 );
					boot_page_fill( Byte_Address, Instruction );
				}
				// Wysanie sumy kontrolnej w celu weryfikacji
				SendByte(crc);
				// Jeeli weryfikacja si powioda to zapisujemy
				if(ReadByte()=='k')
				{
					//Zapisane strony
					boot_page_write( pageAdress );
					boot_spm_busy_wait();
				}
				
			}else //Koniec zapisu flash
			
			// === Odblokowanie sekcji RWW ===
			if(command=='u')
			{
				boot_rww_enable();
			}else
			
			// === ODCZYT Strony FLASH ===
			if(command=='f')
			{
				uint16_t address = ( ( uint16_t )ReadByte() + (ReadByte()<<8));
				uint8_t cnt = SPM_PAGESIZE;
				while(cnt--)
				{
					SendByte( pgm_read_byte_near( address-cnt ) );			
				}
			}else
			
			// === ODCZYT BAJTU EEPROM ===
			if(command=='e')
			{
				SendByte(eeprom_read_byte(( uint8_t* )( uint16_t )ReadByte() + (ReadByte()<<8)) );
			}else
			
			// === ZAPIS BAJTU EEPROM ===
			if(command=='E')
			{
				eeprom_write_byte(( uint8_t* )( uint16_t )ReadByte() + (ReadByte()<<8), ReadByte() );
			}else
			
			break;
		}
	}
	SendByte( 'Q' );
	_delay_loop_2(0);
	//USART OFF
	UCSRB = 0;
	jump_to_app();
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//EOF